package de.lmu.mmi2.exercise5;

import java.util.ArrayList;
import java.util.Random;

import org.mt4j.AbstractMTApplication;
import org.mt4j.MTApplication;
import org.mt4j.components.visibleComponents.shapes.MTRoundRectangle;
import org.mt4j.components.visibleComponents.widgets.MTImage;
import org.mt4j.components.visibleComponents.widgets.MTTextArea;
import org.mt4j.input.gestureAction.DefaultDragAction;
import org.mt4j.input.gestureAction.DefaultRotateAction;
import org.mt4j.input.gestureAction.DefaultScaleAction;
import org.mt4j.input.inputProcessors.IGestureEventListener;
import org.mt4j.input.inputProcessors.MTGestureEvent;
import org.mt4j.input.inputProcessors.componentProcessors.dragProcessor.DragProcessor;
import org.mt4j.input.inputProcessors.componentProcessors.rotateProcessor.RotateProcessor;
import org.mt4j.input.inputProcessors.componentProcessors.scaleProcessor.ScaleProcessor;
import org.mt4j.input.inputProcessors.componentProcessors.tapAndHoldProcessor.TapAndHoldProcessor;
import org.mt4j.input.inputProcessors.componentProcessors.unistrokeProcessor.UnistrokeEvent;
import org.mt4j.input.inputProcessors.componentProcessors.unistrokeProcessor.UnistrokeProcessor;
import org.mt4j.input.inputProcessors.componentProcessors.unistrokeProcessor.UnistrokeUtils.Direction;
import org.mt4j.input.inputProcessors.componentProcessors.unistrokeProcessor.UnistrokeUtils.UnistrokeGesture;
import org.mt4j.input.inputProcessors.globalProcessors.CursorTracer;
import org.mt4j.sceneManagement.AbstractScene;
import org.mt4j.util.MTColor;
import org.mt4j.util.font.FontManager;
import org.mt4j.util.font.IFont;
import org.mt4j.util.math.Vector3D;


public class ImageScene extends AbstractScene {
	
	//Folder where images are located 
	private String imageFolder = "images" + AbstractMTApplication.separator;
	
	//For dispatching unistroke events
	private UnistrokeProcessor usp;
	
	//The multitouch application 
	private MTApplication mtApp;

	//Save if a finger is down on the action button
	private boolean fingerDown = false;
	
	//List of displayed images
	private ArrayList<MTImage> images;
		
	//Store the last image added
	private MTImage lastImageAdded;

	
	public ImageScene(MTApplication mtApplication, String name) {
		super(mtApplication, name);
		this.mtApp = mtApplication;
		images = new ArrayList<MTImage>();

		//Set scene background color
		this.setClearColor(new MTColor(255, 255, 255, 255));
		
		//Add mouse input and show it
		this.registerGlobalInputProcessor(new CursorTracer(mtApplication, this));
		
	}
	
	/**
	 * Draw a scene with images and relevant processors and listeners
	 */
	private void initCanvas() {
		//Remove previous components
		this.getCanvas().removeAllChildren();
		//This area should not respond to drag/scale/rotate events
		//this.getCanvas().unregisterAllInputProcessors(); 
		

		//TODO: Add Action button

		
		//TODO: Add images, make sure to that the image reacts to gestures
		// only when the action button is pressed.
	}
	
	
	/**
	 * Remove the unistroke processor and listener 
	 * @param mti, the image leaving the drag and drop zone
	 */
	private void removeUnistrokeProcessor(MTImage mti) {
	}
	
	/**
	 * Called when a touch is registered in the drag and drop area. A unistroke processor is added to 
	 * and move/scale and resize processors are removed from all images in the area so unistroke gestures 
	 * can be detected without the images moving.
	 */
	private void setFingeDown() {
	}
	
	/**
	 * When no finger is down in the drag and drop zone we remove the unistroke processor and
	 * add default processors to images again
	 */
	private void setFingerUp() {
	}
	
	/**
	 * init the gesture processors
	 */
	public void initGestureProcessors() {
		//Define unistroke processor
		usp = new UnistrokeProcessor(mtApp);

		//Add templates to process by the unistroke processor
		usp.addTemplate(UnistrokeGesture.CIRCLE, Direction.CLOCKWISE);
		usp.addTemplate(UnistrokeGesture.V, Direction.CLOCKWISE);
	}
	
	public void addGestureToProcessor(ArrayList<Vector3D> points, UnistrokeGesture g) {
		//If we have defined a gesture we add it
		if(points != null && points.size() > 0) {
			//TODO: update MT4J code before going further
			//usp.getUnistrokeUtils().getRecognizer().addTemplate(g, points, Direction.CLOCKWISE);
		}

	}
	
	/**
	 * Register a unistroke processor and listen for gesture events.
	 * The templates to match gestures against are the ones we specified in 
	 * the initGestureProcessors() and added with addGestureToProcessor(...)
	 * @param mti, the image listenning to the gestures
	 */
	private void addUnistrokeProcessor(MTImage mti) {
		mti.registerInputProcessor(usp);
		mti.addGestureListener(UnistrokeProcessor.class, new IGestureEventListener() {
			@Override
			/**
			 * If the gesture is being recognized and a finger is pressed in the send the image
			 */
			public boolean processGestureEvent(MTGestureEvent ge) {
				UnistrokeEvent ust = (UnistrokeEvent)ge;
				if(ust.hasTarget() && ust.getId() == MTGestureEvent.GESTURE_ENDED && !ust.getGesture().equals(UnistrokeGesture.NOGESTURE) && fingerDown) {
					//TODO: Perform command on image (add if/then/else conditions)
				}
				return false;
			}
		});
	}

	
	public void onEnter() {}
	
	public void onLeave() {}

	/**
	 * Start drawing the scene
	 */
	@Override
	public void init(){
		initImages();
	};

	@Override
	public void shutDown() {}

}
