﻿package 
{
	import flash.geom.Point;
	
	/**
	 * ear cutting algorithm
	 * @author nicoptere
	 * http://en.nicoptere.net/?p=16
	 */
	public class EarCutting
	{
		
		static private var p:Point;
		static private var p0:Point;
		static private var p1:Point;
		static private var p2:Point;
		
		static private var s:Segment;
		static private var cs0:Segment;
		static private var cs1:Segment;
		static private var cs2:Segment;
		
		static private var det0:Number = 0;
		static private var det1:Number = 0;
		
		static private var t:Triangle;
		
		static private var ear:int = 0;
		static private var breaker:Boolean = false;
		static private var CW:Boolean = true;
		
		
		static private var points:Array = [];
		static private var tmp:Array = [];
		static private var segments:Array = [];
		static private var triangles:Array = [];
		
		
		static public function cut( pts:Array , performSelfIntersectionTest:Boolean = false ) :Array
		{
			
			//if input array is too short
			if ( pts.length < 3 ) return [ new Triangle( pts[0], pts[1], pts[2] ) ];
			
			//if the polygon has the same start/end point, pops the array
			if ( pts[0].x == pts[ pts.length - 1 ].x && pts[0].y == pts[pts.length - 1].y )
			{
				pts.pop();
			}
			
			//working copy
			points = pts.concat();
			
			//builds a list of the polygon's segments
			buildSegments( points );
			
			//check for self intersection
			if ( performSelfIntersectionTest && selfIntersection() ) 
			{
				return [];
			}
			
			// direction of the polygon
			CW = getDirection( points );
			
			//off we go
			process();
			
			return triangles;
			
		}
		
		static public function process():Array
		{
			//current ear being checked
			ear = 0;
			
			//some kind of safety belt...whatever
			breaker = false;
			
			triangles = [];
			
			//working copy of the set of points
			tmp = points.concat();
			
			//recursive function that reduces the set of points until there's only one triangle left
			while ( tmp.length > 2 )
			{
				tmp = earCut( tmp );
				if ( breaker ) 
				{
					return triangles;
				}
			}	
			return triangles;
			
		}
		
		
		static public function earCut( pts:Array ):Array
		{
			//there's only one triangle
			if ( pts.length < 3 ) 
			{
				triangles.push( new Triangle( pts[ 0 ], pts[ 1 ], pts[ 2 ] ) );
				return pts;
			}
			
			//current ear tip being processed
			ear = ( ear < 0 ) ? 0 : ear;
			
			//safety belt 
			if ( pts[ ear ] == null )
			{
				trace( 'p0 is null' );
				breaker = true;
				return pts;
			}
			
			//creates a triangle
			
			p0 = pts[ ear ];
			
			p1 = pts[ ( ear + 1 ) ] ? pts[ ( ear + 1 ) ] : pts[ 0 ];
			
			p2 = pts[ ( ear + 2 ) ] ? pts[ ( ear + 2 ) ] : pts[ 1 ];
			
			t = new Triangle( p0, p1, p2 );
			
			//if the triangle contains one the remaining points: no good, skip to the next
			if ( triangleContainsPoints( t, pts ) )
			{
				ear++;
				return pts;
			}
			
			
			//is the segment inside the shape ?
			
			//those are temporary segments of the triangle being tested
			cs0.p0 = cs2.p1 = p0;
			cs1.p0 = cs0.p1 = p1;
			cs2.p0 = cs1.p1 = p2;
			
			//if that point is outside the shape, we'll have to find another one 
			p = cs2.getCenter();
			
			det0 = determinant( cs0.p0, cs0.p1, p );
			det1 = determinant( cs1.p0, cs1.p1, p );
			
			//depending on the direction ( CW | CCW )
			//the point has to lie either to the left or to the right of both the other segments
			if ( ( CW && det0 > 0 && det1 > 0  ) || ( !CW && det0 < 0 && det1 < 0  ) ) 
			{
				//if not the case > skip to the next
				ear++;
				return pts;
			}
			
			// we have a valid triangle
			triangles.push( t );
			pts.splice( ear + 1, 1 );//the point we were testing is p1
			ear--;
			
			return pts;
			
		}
		
		//determines the polygon's direction: true-> CW | false -> CCW
		static private function getDirection( tmp:Array ):Boolean
		{
			
			var i:int = tmp.length - 1;
			
			p0 = tmp[ i ];
			p1 = tmp[ ( i + 1 ) ] ? tmp[ ( i + 1 ) ] : tmp[ 0 ];
			p2 = tmp[ ( i + 2 ) ] ? tmp[ ( i + 2 ) ] : tmp[ 1 ];
			
			cs0 = new Segment( p0, p1 );
			cs1 = new Segment( p1, p2 );
			cs2 = new Segment( p0, p2 );
			
			var p:Point = cs2.getCenter();
			
			var ip:Point;
			var ep:Point = new Point( p.x + 10000, p.y );
			var cs:Segment = new Segment( p, ep );
			
			//if the count is odd, then the point is inside a shape
			//if it's even, then the point is outside
			var count:int = 0;
			for ( i = 0; i < segments.length; i++ )
			{
				s = segments[ i ];
				ip = s.segmentIntersct( cs, true );
				if ( ip != null )
				{
					count++;
				}
			}
			
			//a little trick i don't get really but does crash the thing if not done: 
			//if the first triangle contains one of the points, we reverse it.
			t = new Triangle( p0, p1, p2 );
			if ( count % 2 == 0 && !triangleContainsPoints( t, tmp ) ) tmp.reverse();
			
			det0 = determinant( cs0.p0, cs0.p1, p );
			det1 = determinant( cs1.p0, cs1.p1, p );
			
			return ( det0 < 0 && det1 < 0 );
			
		}
		
		//is the polygon simple?
		static public function selfIntersection():Boolean 
		{
			var ss:Segment;
			var ip:Point;
			for each( s in segments )
			{
				for each( ss in segments )
				{
					if ( s != cs0 )
					{
						ip = s.segmentIntersct( ss, true );
						if ( ip != null 
						&& !(s.p0.equals(ss.p0) || s.p0.equals(ss.p1) )
						&& !(s.p1.equals(ss.p0) || s.p1.equals(ss.p1) ))
						{
							return true;
						}
					}
				}
			}
			return false;
		}
		
		static public function buildSegments( points:Array ):Array 
		{
			segments = [];
			for ( var i:int = 0; i < points.length; i++ )
			{
				
				p0 = points[ i ];
				p1 = points[ i + 1 ] ? points[ i + 1 ] : points[ 0 ];
				s = new Segment( p0, p1 );
				segments.push( s );
				
			}
			return segments;
		}
		
		static private function triangleContainsPoints( t:Triangle, pts:Array ):Boolean
		{
			var i:int;
			var PL:int = pts.length;
			for ( i = 0; i < PL; i++ )
			{
				p = pts[ i ];
				if ( p != p0 && p != p1 && p != p2 )
				{
					if ( t.contains( p ) )
					{
						return true;
					}
				}
			}
			return false;
		}
		
		static public function determinant( p0:Point, p1:Point, p2:Point ):Number
		{
			return ( ( p0.x-p1.x )*( p2.y - p1.y ) ) - ( ( p2.x-p1.x )*( p0.y-p1.y ) );
		}
	}
		
}