var FLG_writingLogVal_UsaProxy;	// flag: if set, writing log entry to logVal_UsaProxy not possible
var FLG_LogMousemove_UsaProxy;	// flag: if set, mouse move logging disabled
var IVL_scrollCheck_UsaProxy;	// interval function variable for processScroll_UsaProxy()
var IVL_saveLog_UsaProxy;		// interval function variable for saveLog_UsaProxy()
var lastScrollPosY_UsaProxy;	// last position of vertical scrollbar resp. top offset of document
var lastScrollPosX_UsaProxy;	// last position of vhorozontal scrollbar resp. left offset of document
var logVal_UsaProxy;			// Initialised when page loads. Contains current event log entries

var keyName_UsaProxy;			// holds current pressed key/key combination
var FLG_ctrlPressed_UsaProxy;	// flag is set when ctrl-key is pressed (and reset when released)
var FLG_ctrl_comb_UsaProxy;		// additional flag for ctrl+key combinations
var FLG_altPressed_UsaProxy;	// flag is set when alt-key is pressed (and reset when released)
var FLG_shiftPressed_UsaProxy;	// flag is set when shift-key is pressed (and reset when released)
var FLG_keyPress_UsaProxy;		// flag disables keypress check; set when any of the control keys is pressed
var FLG_comb_UsaProxy;			// flag indicates a key combination
var combMembers_UsaProxy;		// number of remaining unreleased keys if a key combination was pressed

var lastSelection_UsaProxy;		// last selected text
var serverdataId_UsaProxy;      /* contains related serverdata ID defined by UsaProxy 
								 * serverdata ID references resp. txt file which contains
								 * the full request and response headers and data
								 * serverdata ID is used instead document URL */
var requester_UsaProxy;			// holds current XMLHttpRequest object

/* initializes all variables, event handlers, and interval functions
 * invokes load event log 
 */
function init_UsaProxy() {
	
	logVal_UsaProxy 			= "";
	window.status 				= "";
	FLG_writingLogVal_UsaProxy 	= false;
	FLG_LogMousemove_UsaProxy 	= false;
	
	/* initialize lastScrollPos_UsaProxy with current top/left offset */
	lastScrollPosY_UsaProxy 	= (window.Event) ? window.pageYOffset : document.body.scrollTop;
	lastScrollPosX_UsaProxy 	= (window.Event) ? window.pageXOffset : document.body.scrollLeft;
	
	lastSelection_UsaProxy 		= "";
	
	keyName_UsaProxy 			= "";
	FLG_ctrlPressed_UsaProxy 	= false;
	FLG_ctrl_comb_UsaProxy		= false;
	FLG_altPressed_UsaProxy 	= false;
	FLG_shiftPressed_UsaProxy 	= false;
	FLG_keyPress_UsaProxy 		= true;
	FLG_comb_UsaProxy 			= false;
	combMembers_UsaProxy 		= 0;
	
	/* get initial XMLHttpRequest object */
	requester_UsaProxy 			= getRequester_UsaProxy();
	
	/* retrieve current serverdata ID which is appended to script src URL */
	serverdataId_UsaProxy   = document.getElementById("proxyScript_UsaProxy").src;
	serverdataId_UsaProxy	= serverdataId_UsaProxy.substring(serverdataId_UsaProxy.indexOf("?id=")+4);
	
	/* log load event */
	processLoad_UsaProxy();
	
	/* registration of event handlers
	 * most event handlers are attached to the document/window element
	 * mouse events "bubble" from the target element (such as a button)
	 * to the document element and can be captured there
	 * other events such as focus, blur, change need to be directly
	 * captured at the target element */
	
	// NS explicit event capturing
	if(window.Event) {
		document.captureEvents(Event.CHANGE | Event.MOUSEUP | Event.KEYPRESS | Event.KEYDOWN | Event.KEYUP | Event.MOUSEMOVE | Event.MOUSEOVER | Event.FOCUS | Event.BLUR | Event.UNLOAD | Event.SELECT);
		window.captureEvents(Event.RESIZE);
	}
	
	/* attach event handlers to avoid overwriting
	 * IE: attachEvent
	 * NS: addEventListener */
	 
	// IE
	if(document.attachEvent) { 
	
		document.attachEvent('onmouseup', processMouseup_UsaProxy);
		
		/* change, focus, and blur Handler for each relevant element
		 * dropdowns, lists, text fields/areas, file fields, password fields, and checkboxes: onchange handler
		 * lists, text fields/areas, file fields, and password fields: onfocus/onblur handler */
		for (var i = 0; i < document.forms.length; ++i) {
			for (var j = 0; j < document.forms[i].elements.length; ++j) {
				if(document.forms[i].elements[j].type) {
					var elType = document.forms[i].elements[j].type;
					if (elType=="select-one" || elType=="select-multiple" || elType=="text" || elType=="textarea" || elType=="file" || elType=="checkbox" || elType=="password") {
						document.forms[i].elements[j].attachEvent('onchange', processChange_UsaProxy);
					}
					if (elType=="text" || elType=="textarea" || elType=="file" || elType=="password" || elType=="select-multiple") {
						document.forms[i].elements[j].attachEvent('onfocus', processFocus_UsaProxy);
						document.forms[i].elements[j].attachEvent('onblur', processBlur_UsaProxy);
					}
				}
			}
		}
		
		document.attachEvent('onkeypress', processKeypress_UsaProxy);
		document.attachEvent('onkeydown', processKeydown_UsaProxy);
		document.attachEvent('onkeyup', processKeyup_UsaProxy);
		document.attachEvent('onmousemove', processMousemove_UsaProxy);
		document.attachEvent('onmouseover', processMouseover_UsaProxy);
		window.attachEvent('onresize', processResize_UsaProxy);
		document.attachEvent('onunload', processUnload_UsaProxy);
	}
	
	// NS
	if(document.addEventListener) {
		document.addEventListener('mouseup', processMouseup_UsaProxy, false);
		
		/* change, focus, and blur Handler for each relevant element
		 * dropdowns, lists, text fields/areas, file fields, password fields, and checkboxes: onchange handler
		 * lists, text fields/areas, file fields, and password fields: onfocus/onblur handler
		 * text fields/areas: onselect handler */
		for (var i = 0; i < document.forms.length; ++i) {
			for (var j = 0; j < document.forms[i].elements.length; ++j) {
				if(document.forms[i].elements[j].type) {
					var elType = document.forms[i].elements[j].type;
					if (elType=="select-one" || elType=="select-multiple" || elType=="text" || elType=="textarea" || elType=="file" || elType=="checkbox" || elType=="password") {
						document.forms[i].elements[j].addEventListener('change', processChange_UsaProxy, false);
					}
					if (elType=="text" || elType=="textarea" || elType=="file" || elType=="password" || elType=="select-multiple") {
						document.forms[i].elements[j].addEventListener('focus', processFocus_UsaProxy, false);
						document.forms[i].elements[j].addEventListener('blur', processBlur_UsaProxy, false);
					}
					if (elType=="text" || elType=="textarea") {		// NS text select event detection
						document.forms[i].elements[j].addEventListener('select', processSelectionNS_UsaProxy, false);
					}
				}
			}
		}
	
		document.addEventListener('keypress', processKeypress_UsaProxy, false);
		document.addEventListener('keydown', processKeydown_UsaProxy, false);
		document.addEventListener('keyup', processKeyup_UsaProxy, false);
		document.addEventListener('mousemove', processMousemove_UsaProxy, false);
		document.addEventListener('mouseover', processMouseover_UsaProxy, false);
		window.addEventListener('resize', processResize_UsaProxy, false);
		document.addEventListener('unload', processUnload_UsaProxy, false);
	}
	
	/* instantiate scroll check and save function being invoked periodically */
	IVL_scrollCheck_UsaProxy 	= window.setInterval("processScroll_UsaProxy()",1000);
	IVL_saveLog_UsaProxy 		= window.setInterval("saveLog_UsaProxy()",3000);
}

/* init is invoked on load */
if(document.attachEvent) window.attachEvent('onload', init_UsaProxy);
if(document.addEventListener) window.addEventListener('load', init_UsaProxy, false);

// Returns string of the form "2004-12-31,23:59:59"
function datestamp_UsaProxy() {
	var startDate_UsaProxy = new Date();
	return startDate_UsaProxy.getFullYear() + "-" + completeDateVals(startDate_UsaProxy.getMonth()+1) + "-"
	  + completeDateVals(startDate_UsaProxy.getDate()) + "," + completeDateVals(startDate_UsaProxy.getHours())
	  + ":" + completeDateVals(startDate_UsaProxy.getMinutes())
	  + ":" + completeDateVals(startDate_UsaProxy.getSeconds());
}

// completes one-digit numbers by a leading zero
function completeDateVals(dateVal) {
	var dateVal = "" + dateVal;
	if (dateVal.length<2) return "0" + dateVal;
	else return dateVal;
}
  
/* Attaches an event log entry together with the serverdata ID
 * and current and timestamp to logVal_UsaProxy */
function writeLog_UsaProxy(text) {
	// if function is already executed defer writeLog_UsaProxy for 50ms
	if(FLG_writingLogVal_UsaProxy) { window.setTimeout("writeLog_UsaProxy(" + text + ")",50); return false;}
	// set synchronization flag (block function)
	FLG_writingLogVal_UsaProxy = true;
		var logline = datestamp_UsaProxy() + " " + serverdataId_UsaProxy + " " + text;
		logVal_UsaProxy = logVal_UsaProxy + logline + "--"; // Add logLine to interaction log
	// reset synchronization flag (release function)
	FLG_writingLogVal_UsaProxy = false;
}

// returns XMLHttpRequest object
function getRequester_UsaProxy() {
	try { 
	 	return new XMLHttpRequest(); // NS
	} catch (error) { 
	 	try { 
	   		return new ActiveXObject("Microsoft.XMLHTTP");   // IE
	 	} catch (error) { 
	   		return null; 	// e.g. if ActiveX disabled
	 	} 
	}
}

// sends logVal_UsaProxy content to UsaProxy and resets it
function saveLog_UsaProxy() {
	// if new logs available
	if(logVal_UsaProxy!="") {
		var logVal = logVal_UsaProxy;
		logVal_UsaProxy = ""; // reset log data
		/* if XMLHttpRequest object not available resp. Active X is disabled (IE)
		 * regular image.src request is performed */
		if(requester_UsaProxy==null) {
			var loadImage = new Image(); 
			//loadImage.src = "http://lo.lo/usaproxylolo/img.jpg?" + logVal;
			loadImage.src = "/usaproxylolo/img.jpg?" + logVal;
		/* XMLHttpRequest is available
		 * Ajax request to server */
		} else {
			//window.status = "requester_UsaProxy available";
			requester_UsaProxy = getRequester_UsaProxy(); // new XMLHttpRequest object
			requester_UsaProxy.open("GET", "/usaproxylolo/img.jpg?" + logVal);
			requester_UsaProxy.send(null);
		}
	}
}

// returns available target data such as DOM path, img name, href, etc.
function generateEventString_UsaProxy(node) {
	var eventString = "";
	eventString = eventString + " dom=" + getDOMPath(node);  // DOM path
	
	// if target has href attribute
	if (node.href) {
		/* image detection IE: IE doesn't register any src attribute
		 * instead href contains the file path */
		if(node.nodeName=="img" || node.nodeName=="IMG") {	
			// if linked image (parent node is <a> node)
			if(node.parentNode.href)  
				eventString = eventString + " img=" + getFileName(node.href) + " link=" + node.parentNode.href;
			else eventString = eventString + " img=" + getFileName(node.href);
		}
		// NS+IE: link detection
		else if(node.nodeName=="a" || node.nodeName=="A") {  // if anchor tag
			// IE: innertext attribute contains link text
			if (node.innerText)
				eventString = eventString + " link=" + node.href + " text=" + escape(node.innerText);
			// NS: text attribute contains link text
			else eventString = eventString + " link=" + node.href + " text=" + escape(node.text);
		}
	} else {
		// image detection NS
		if (node.src) {		
			if (node.parentNode.href)
				eventString = eventString + " img=" + getFileName(node.src) + " link=" + node.parentNode.href
			else eventString = eventString + " img=" + getFileName(node.src);
		}
	}
	
	return eventString;
}

/* returns filename of a URL/path */
function getFileName(path) {
	if(path.lastIndexOf("/")>-1)
		return path.substring(path.lastIndexOf("/")+1);
	else return path;
}

/* processes mouse release event */
function processMouseup_UsaProxy(e) {
	// check if text was selected, if true discontinue
	if(processSelection_UsaProxy()) return;
	
	/* get target, x, and y value of mouse position
	 * NS: first case (window.Event available); IE: second case */
	var ev 		= (window.Event) ? e : window.event;
	var target 	= (window.Event) ? ev.target : ev.srcElement;
	var x 		= (window.Event) ? ev.pageX : ev.offsetX;
	var y 		= (window.Event) ? ev.pageY : ev.offsetY;
	
	/** mouse button detection: was middle or right mouse button clicked ?*/
	var mbutton = "left";
	if (ev.which) {  		// NS
		switch(ev.which) {
			case 2: mbutton = "m"; break;	// middle button
			case 3: mbutton = "r"; break;	// right button
		}
	} else if (ev.button) {		// IE
		switch(ev.button) {
			case 4: mbutton = "m"; break;
			case 2: mbutton = "r"; break;
		}
	}
	// log middle and left button events, continue if left button was clicked
	if (mbutton!="left") {
		writeLog_UsaProxy("click but=" + mbutton + generateEventString_UsaProxy(target));
		saveLog_UsaProxy();
		return;
	}
	/* end mouse button detection */
	
	// dropdown selection event is handled by function processChange_UsaProxy
	if(target.nodeName=="OPTION" || target.nodeName=="option") return; // do nothing
	if(target.nodeName=="SELECT" || target.nodeName=="select") return; // do nothing
	
	if(target.type) {
		// if radiobutton was clicked; log value of clicked radiobutton, discontinue afterwards
		if(target.type == "radio") {
			if (target.id) 	writeLog_UsaProxy("select radio id=" + target.id + " value="
											  + escape(target.value) + generateEventString_UsaProxy(target));
			else { if (target.name) writeLog_UsaProxy("select radio name=" + target.name
											+ " value=" + escape(target.value) + generateEventString_UsaProxy(target)); }
			saveLog_UsaProxy();
			return;
		}
	}
	
	// if regular click log click coordinates and all available target attributes
	// if element has an id attribute
	if (target.id) 	writeLog_UsaProxy("click coord=" + x + "," + y
							+ " id=" + target.id + generateEventString_UsaProxy(target) );
	else {
		// if element has a name attribute
		if(target.name) writeLog_UsaProxy("click coord=" + x + "," + y
								+ " name=" + target.name + generateEventString_UsaProxy(target));
		else {
			writeLog_UsaProxy("click coord=" + x + "," + y + generateEventString_UsaProxy(target));
		}
	}
	saveLog_UsaProxy();
}

/* returns element path beginning with the first
 * corresponding child node of the document node (i.e. HTML)*/
function getDOMPath(node) {
	/* if nodeType==9 same as nodetype==Node.DOCUMENT_NODE, IE doesn't speak constants */
	if(node.parentNode.nodeType==9) return getDOMIndex(node);
	else return getDOMPath(node.parentNode) + getDOMIndex(node);
}

function getDOMIndex(node) {
	var parent = node.parentNode;
	var children = parent.childNodes;
	var length = children.length;
	var position = 0;
	for (var i = 0; i < length; i++) {
		/* if nodeType==1 same as nodetype==Node.ELEMENT_NODE, IE doesn't speak constants */
		if (children[i].nodeType==1) { // count only element nodes
			position += 1;
			if (children[i] == node) return mapToAlph(position);
		} 
	}
}

/* hex representation of DOM path
 * e.g. having a path of <HTML><BODY><FORM><P>1st<INPUT>
 * results in 2h2h1h1h1h
 * e.g. having a path of <HTML><BODY><FORM><P>34th<INPUT>
 * results in 2h2h1h1h22h
 * with an "h" as hex suffix */
function mapToHex(position) {
	return (position.toString(16) + "h");
}

/* alphabetic representation of DOM path
 * e.g. having a path of <HTML><BODY><FORM><P>1st<INPUT>
 * results in bbaaa
 * e.g. having a path of <HTML><BODY><FORM><P>34th<INPUT>
 * results in bbaa1h
 * with an optional number as prefix which indicates the extent
 * to which the position exceeds the number of characters available
 * e.g. a position of 54 is represented by 2b (= 2x26 + b)*/
var alphArray = ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"]
function mapToAlph(position) {
	var amountAlphs = 0;
	var alphRemain = "";
	if(position>alphArray.length) { // if position > available indexes
		amountAlphs = Math.floor(position/alphArray.length);
		alphRemain = alphArray[(position % alphArray.length)-1];
	} 
	if(amountAlphs>0) return (amountAlphs + alphRemain);
	return (alphArray[position-1]);
}

/* processes change event
 * only available for select, input, textarea */
function processChange_UsaProxy(e) {
	
	/* get target
	 * NS: first case (window.Event available); IE: second case */
	var ev 		= (window.Event) ? e : window.event;
	var target 	= (window.Event) ? ev.target : ev.srcElement;
	
	// if list
	if (target.type=="select-multiple") {
		var value = "";
		// check which entries were selected
		for (var i = 0; i < target.options.length; i++)
    		if (target.options[ i ].selected) value = value + target.options[ i ].value;
		// log entries
		if (target.id) {
			writeLog_UsaProxy("select select-multiple id=" + target.id
						+ " value=" + escape(value) + generateEventString_UsaProxy(target));
		} else { if (target.name)
					writeLog_UsaProxy("select select-multiple name=" + target.name
						+ " value=" + escape(value) + generateEventString_UsaProxy(target));
		}
		saveLog_UsaProxy();
	}
	
	// if dropdown log selected entry's value
	if (target.type=="select-one") { 
		if (target.id) {
			writeLog_UsaProxy("select select-one id=" + target.id + " value="
					+ escape(target.options[target.selectedIndex].value) + generateEventString_UsaProxy(target));
		} else { if (target.name)
					writeLog_UsaProxy("select select-one name=" + target.name
							+ " value=" + escape(target.options[target.selectedIndex].value)
							+ generateEventString_UsaProxy(target));
		}
		saveLog_UsaProxy();
	}
	
	// if text field/area, file field: log changed value
	else if (target.type=="text" || target.type=="textarea" || target.type=="file") {
		if (target.id) {
			writeLog_UsaProxy("change " + target.type + " id=" + target.id
							  + " value=" + escape(target.value) + generateEventString_UsaProxy(target));
		} else { if (target.name)
					writeLog_UsaProxy("change " + target.type + " name="
							+ target.name + " value=" + escape(target.value) + generateEventString_UsaProxy(target));
		}
		saveLog_UsaProxy();
	}
	
	// log if checkbox was checked/unchecked
	else if (target.type=="checkbox") {
		var value = "";
		// check boxes in checkbox group
		if(target.length>1) { 
			for ( i=0 ; i < target.length ; i++ ){ 
   				if (target[i].checked==true)  
 					value = value + "." + target[i].value;
			}
			if (value=="") value = "none";
		// single checkbox
		} else {value==target.checked}
		// log entries
		if (target.id) {
			writeLog_UsaProxy("change " + target.type + " id=" + target.id
							  + " checked=" + target.checked + generateEventString_UsaProxy(target));
		} else { if (target.name)
					writeLog_UsaProxy("change " + target.type + " name="
							+ target.name + " checked=" + target.checked + generateEventString_UsaProxy(target));
		}
		saveLog_UsaProxy();
	}
	
	// if password field log only THAT content was modified
	else if (target.type=="password") {
		if (target.id) {
			writeLog_UsaProxy("change " + target.type + " id="
							  + target.id + generateEventString_UsaProxy(target));
		} else { if (target.name)
					writeLog_UsaProxy("change " + target.type + " name="
									  + target.name + generateEventString_UsaProxy(target));
		}
		saveLog_UsaProxy();
	}
	
}

/* detection of key combinations: first part - key down
 * flags are set in case shift, ctrl, or alt is pressed
 * in case any flag is true a combination is detected and logged  */
function processKeydown_UsaProxy(e) {

	/* get keycode
	 * IE: first case (window.event available); NS: second case */
	var evtobj 				= window.event ? window.event : e;
	var KeyID 				= evtobj.which ? evtobj.which : evtobj.keyCode;
	FLG_ctrl_comb_UsaProxy 	= false;	// "ctrl key pressed" combinations flag

	switch(KeyID)
	{
		// if shift is pressed
		case 16:		
			FLG_comb_UsaProxy = false;			// reset combination flag
			combMembers_UsaProxy = 0;			// reset combination members
			FLG_shiftPressed_UsaProxy = true;	// set "shift key pressed" flag
			FLG_keyPress_UsaProxy = false;		// keypress-event blocked (keypress event is blocked)
			return false;
		break;
		// if ctrl is pressed
		case 17:		
			FLG_comb_UsaProxy = false;			// reset combination flag
			combMembers_UsaProxy = 0;			// reset combination members
			FLG_ctrlPressed_UsaProxy = true;	// set "ctrl key pressed" flag
			FLG_keyPress_UsaProxy = false;		// keypress-event blocked
			return false;
		break;
		// if alt is pressed
		case 18:		
			FLG_comb_UsaProxy = false;			// reset combination flag
			combMembers_UsaProxy = 0;			// reset combination members
			FLG_altPressed_UsaProxy = true;		// set "alt key pressed" flag
			FLG_keyPress_UsaProxy = false;		// keypress-event blocked
			return false;
		break;
	}
	
	/** the following code is only executed for the character key in a key combination */
	
	/** combination check: if shift-char combination */
	if (FLG_shiftPressed_UsaProxy) {			// if shift was already pressed: keyID holds the char which follows shift
		keyName_UsaProxy = String.fromCharCode(KeyID);	// Select capital
		FLG_comb_UsaProxy = true;		// set key combination flag
		combMembers_UsaProxy = 2;	// 2 keys pressed
	}
	/** combination check: if ctrl-char combination */
	if (FLG_ctrlPressed_UsaProxy) {
		switch(KeyID) {		// if ctrl was already pressed: keyID holds the char which follows ctrl
			case 65: keyName_UsaProxy = "ctrl a"; break;	// Select Alls command
			case 66: keyName_UsaProxy = "ctrl b"; break;	// Edit bookmarks command
			case 67: keyName_UsaProxy = "ctrl c"; break;	// Copy command
			case 68: keyName_UsaProxy = "ctrl d"; break;	// Add bookmark command
			case 69: keyName_UsaProxy = "ctrl e"; break;
			case 70: keyName_UsaProxy = "ctrl f"; break;	// Find command
			case 71: keyName_UsaProxy = "ctrl g"; break;	// NS: find Again command
			case 72: keyName_UsaProxy = "ctrl h"; break;	// NS: open history command
			case 73: keyName_UsaProxy = "ctrl i"; break;	// NS: page info command
			case 74: keyName_UsaProxy = "ctrl j"; break;	// NS: downloads box
			case 75: keyName_UsaProxy = "ctrl k"; break;	// NS: google search bar
			case 76: keyName_UsaProxy = "ctrl l"; break;	// IE: open command
			case 77: keyName_UsaProxy = "ctrl m"; break;	
			case 78: keyName_UsaProxy = "ctrl n"; break;	// IE: new window NS: new message command
			case 79: keyName_UsaProxy = "ctrl o"; break;	// Open command
			case 80: keyName_UsaProxy = "ctrl p"; break;	// Print command
			case 81: keyName_UsaProxy = "ctrl q"; break;	// NS: exit command
			case 82: keyName_UsaProxy = "ctrl r"; break;	// Reload command
			case 83: keyName_UsaProxy = "ctrl s"; break;	// Save command
			case 84: keyName_UsaProxy = "ctrl t"; break;	
			case 85: keyName_UsaProxy = "ctrl u"; break;	// NS: page source command
			case 86: keyName_UsaProxy = "ctrl v"; break;	// Paste command
			case 87: keyName_UsaProxy = "ctrl w"; break;	// Close command
			case 88: keyName_UsaProxy = "ctrl x"; break;	// Cut command
			case 89: keyName_UsaProxy = "ctrl y"; break;	// Select Alls command
			case 90: keyName_UsaProxy = "ctrl z"; break;	// Select Alls command
		}
		
		// log ctrl+key combination
		writeLog_UsaProxy("keypress key=" + keyName_UsaProxy);
		saveLog_UsaProxy();
		
		keyName_UsaProxy 			= "";				// reset keyName_UsaProxy
		
		/* reset ctrl key pressed flag already at keydown since NS doesn't
		 * trigger any keyup event in case of e.g. ctrl-f */
		FLG_ctrlPressed_UsaProxy 	= false;
		FLG_ctrl_comb_UsaProxy		= true;		/* set additional flag true to be able to
												 * determine a ctrl+key below although FLG_ctrlPressed_UsaProxy
												 * was already set false above */
		
		/* unlock handling of regular key presses:
		 * enable processKeyUp_UsaProxy functionality */
		FLG_keyPress_UsaProxy 		= true;
		
		FLG_comb_UsaProxy 			= true;			// set key combination flag
		combMembers_UsaProxy 		= 2;			// 2 keys pressed
	}
	
	/* NS: in case a combination (ctrl+key) was requested before
	 * which triggered a platform action (such as focus on Firefox find box)
	 * the keyup event won't be triggered. Therefore a reset of a possible
	 * combination must be performed on keydown
	 * since FLG_ctrlPressed_UsaProxy is set false above in the
	 * "if (FLG_ctrlPressed_UsaProxy)" block the additional variable
	 * FLG_ctrl_comb_UsaProxy is used */
	if(!FLG_ctrl_comb_UsaProxy && !FLG_shiftPressed_UsaProxy && !FLG_altPressed_UsaProxy) {
		FLG_comb_UsaProxy 			= false;			// reset key combination flag
		combMembers_UsaProxy 		= 0;
	}
	
}

/* release of key combinations: second part - key up/released
 * flags are reset in case shift, ctrl, or alt is released
 * in case any flag is true a combination is detected and logged  */
function processKeyup_UsaProxy(e) {

	/* get keycode
	* IE: first case (window.event available); NS: second case */
	var evtobj 	= window.event ? window.event : e;
	var KeyID 	= evtobj.which ? evtobj.which : evtobj.keyCode;
	
	// control key check
	switch(KeyID)
	{	
		// if shift is released
		case 16:
			// in case combination was pressed
			if(FLG_comb_UsaProxy==true) {
				/* if shift key is the first key of the combination which is released
				 * decrease number of remaining combination members */
				if (combMembers_UsaProxy==2) combMembers_UsaProxy=1;
				/* if shift is last released key of the combination */
				else {	
					FLG_comb_UsaProxy 			= false;	// reset key combination
					writeLog_UsaProxy("keyPress key=" + keyName_UsaProxy);	// log key combination
					keyName_UsaProxy 			= "";		// reset key name
					FLG_shiftPressed_UsaProxy 	= false;	// reset shift pressed flag
					FLG_keyPress_UsaProxy 		= true;		// re-enable keypress event processing
				}
				return false;
			// if shift was pressed without combining it with another key
			} else {
				keyName_UsaProxy 			= "shift";		// set key name	
				FLG_shiftPressed_UsaProxy 	= false;		// reset shift pressed flag
				FLG_keyPress_UsaProxy 		= true;			// re-enable keypress event processing
			}
		break;
		/* if ctrl is released and no key combination was pressed (single ctrl press)
		 * since all combination reset actions were already performed on keydown
		 * no key combination resetting neccessary at this point */
		case 17:
			if(FLG_comb_UsaProxy==false && FLG_ctrlPressed_UsaProxy) {
				keyName_UsaProxy 			= "ctrl";		// set key name
				FLG_ctrlPressed_UsaProxy 	= false;		// reset ctrl pressed flag
				FLG_keyPress_UsaProxy 		= true;			// re-enable keypress event processing
			} 
		break;
		// if alt is released
		case 18:
			if(FLG_comb_UsaProxy==true) {
				/* if alt key is the first key of the combination which is released
				 * decrease number of remaining combination members */
				if (combMembers_UsaProxy==2) combMembers_UsaProxy=1;
				else {	
					FLG_comb_UsaProxy 		= false;		// reset key combination
					writeLog_UsaProxy("keypress key=" + keyName_UsaProxy);
					keyName_UsaProxy 		= "";			// reset key name
					FLG_altPressed_UsaProxy = false;		// reset alt pressed flag
					FLG_keyPress_UsaProxy 	= true;			// re-enable keypress event processing
				}
				return false;
			// if alt was pressed without combining it with another key
			} else {
				keyName_UsaProxy 			= "alt";		// set key name
				FLG_altPressed_UsaProxy 	= false;		// reset alt pressed flag
				FLG_keyPress_UsaProxy 		= true;			// re-enable keypress event processing
			}
		break;
		// set key name in case of other control keys
		case 19: keyName_UsaProxy = "pause"; break;			// set key name
		case 37: keyName_UsaProxy = "arrow left"; break;	// set key name
		case 38: keyName_UsaProxy = "arrow up"; break;		// set key name
		case 39: keyName_UsaProxy = "arrow right"; break;	// set key name
		case 40: keyName_UsaProxy = "arrow down"; break; 	// set key name
		case 46: keyName_UsaProxy = "del"; break; 			// set key name
	}
	
	/* if combination is released (except ctrl+key since all flags
	 * are released on keydown)
	 * if first key of combination, decrease number of combination members
	 * else, reset combination flag */
	if(FLG_comb_UsaProxy) {
		if (combMembers_UsaProxy==2) combMembers_UsaProxy=1;
		else	FLG_comb_UsaProxy = false;
	}

	/* log a single key press or a key combination
	 * single press or end of key combination (last member to be released)
	 * is true if flag FLG_comb_UsaProxy is false and
	 * also the additional ctrl+key combination indicator (since
	 * resetting of all ctrl+key combination (except FLG_ctrl_comb_UsaProxy)
	 * flags occurs on keydown) */
	if(FLG_comb_UsaProxy==false && !FLG_ctrl_comb_UsaProxy) {
		writeLog_UsaProxy("keypress key=" + keyName_UsaProxy);
		saveLog_UsaProxy();
		keyName_UsaProxy = "";
	}
}

/* onkeypress: all reguler single key presses are logged
 * if keyPress flag is enabled (in case no control key is clicked at the same time)
 * for regular char keys the keyPress event returns the correct small case key code */
function processKeypress_UsaProxy(e) {
	if(FLG_keyPress_UsaProxy) {
		/* get keycode
		 * IE: first case (window.event available); NS: second case */
		var evtobj 	= window.event ? window.event : e;
		var KeyID 	= evtobj.which ? evtobj.which : evtobj.keyCode;
		keyName_UsaProxy = String.fromCharCode(KeyID);
	}
}

/* processes mouseover event
 * logs mouseover events on all elements which have either an
 * id, name, href, or src attribute (more would cause a log overload) */ 
function processMouseover_UsaProxy(e) {
	
	/* get target, x, and y value of mouse position
	 * NS: first case (window.Event available); IE: second case */
	var ev = (window.Event) ? e : window.event;
	var target = (window.Event) ? ev.target : ev.srcElement;
	var x = (window.Event) ? ev.pageX : ev.offsetX;
	var y = (window.Event) ? ev.pageY : ev.offsetY; 
	
	// log mouseover coordinates and all available target attributes
	// if element has an id attribute
	if (target.id) 	writeLog_UsaProxy("mouseover coord=" + x + "," + y + " id=" + target.id + generateEventString_UsaProxy(target));
	else {
		// if element has a name attribute
		if(target.name) writeLog_UsaProxy("mouseover coord=" + x + "," + y + " name=" + target.name + generateEventString_UsaProxy(target));
		else {
			// if element has an href or src attribute
			if (target.href || target.src)
				writeLog_UsaProxy("mouseover coord=" + x + "," + y + generateEventString_UsaProxy(target));
		}
	}
}

/* processes mousemove event if FLG_LogMousemove_UsaProxy isn't set */
function processMousemove_UsaProxy(e) {
	
	/* get target, x, and y value of mouse position
	 * NS: first case (window.Event available); IE: second case */
	var ev 		= (window.Event) ? e : window.event;
	var target 	= (window.Event) ? ev.target : ev.srcElement;
	var x 		= (window.Event) ? ev.pageX : ev.offsetX;
	var y 		= (window.Event) ? ev.pageY : ev.offsetY; 
	
	// if log mousemove flag is false, set it true and log a mousemove event
	if (!FLG_LogMousemove_UsaProxy) {
		FLG_LogMousemove_UsaProxy = true;
		logMousemove_UsaProxy(x,y);
	}
}

/* logs a mousemove event and defers the reset of the log mousemove flag */
function logMousemove_UsaProxy(x,y) {
	writeLog_UsaProxy("mousemove coord=" + x + "," + y);
	window.setTimeout('setInaktiv_UsaProxy()',300);
}

/* resets the log mousemove flag so that a next mousemove event may occur */
function setInaktiv_UsaProxy() {
	FLG_LogMousemove_UsaProxy = false;
}

/* processes blur event */
function processBlur_UsaProxy(e) {
	/* get target
	 * NS: first case (window.Event available); IE: second case */
	var ev 		= (window.Event) ? e : window.event;
	var target 	= (window.Event) ? ev.target : ev.srcElement;
	
	// log all available target attributes
	// if element has an id attribute
	if (target.id) {
		writeLog_UsaProxy("blur id=" + target.id + generateEventString_UsaProxy(target));
	// if element has a name attribute
	} else {if (target.name) writeLog_UsaProxy("blur name=" + target.name + generateEventString_UsaProxy(target));
			// all others
			else
				writeLog_UsaProxy("blur" + generateEventString_UsaProxy(target));
	}
	//saveLog_UsaProxy();
}

/* processes focus event */
function processFocus_UsaProxy(e) {
	/* get target
	 * NS: first case (window.Event available); IE: second case */
	var ev 		= (window.Event) ? e : window.event;
	var target 	= (window.Event) ? ev.target : ev.srcElement;
	
	// log all available target attributes
	// if element has an id attribute
	if (target.id) {
		writeLog_UsaProxy("focus id=" + target.id + generateEventString_UsaProxy(target));
	// if element has a name attribute
	} else { if (target.name) writeLog_UsaProxy("focus name=" + target.name + generateEventString_UsaProxy(target));
			// all others
			else
				writeLog_UsaProxy("focus" + generateEventString_UsaProxy(target));
	}
	//saveLog_UsaProxy();
}

/* processes window resize event */
function processResize_UsaProxy(e) {
	/* get size
	 * NS: first case (window.innerWidth/innerHeight available); IE: second case */
	var newWidth, newHeight;
	newWidth 	= (window.innerWidth) ? window.innerWidth : document.body.offsetWidth;  // innerWidth=NS
	newHeight 	= (window.innerHeight) ? window.innerHeight : document.body.offsetHeight;  // innerHeight=NS
	writeLog_UsaProxy("resize size=" + newWidth + "x" + newHeight);
	saveLog_UsaProxy();
}

/* processes load event */
function processLoad_UsaProxy(e) {
	/* get size
	 * NS: first case (window.innerWidth/innerHeight available); IE: second case */
	var loadWidth, loadHeight;
	loadWidth 	= (window.innerWidth) ? window.innerWidth : document.body.offsetWidth;  // innerWidth=NS
	loadHeight 	= (window.innerHeight) ? window.innerHeight : document.body.offsetHeight;  // innerHeight=NS
	writeLog_UsaProxy("load size=" + loadWidth + "x" + loadHeight);
	//saveLog_UsaProxy();
}

/* processes unload event */
function processUnload_UsaProxy(e) {
	writeLog_UsaProxy("unload");
	saveLog_UsaProxy();
}

/* processes scrolling event
 * function is invoked periodically since no explicit scoll event available */
function processScroll_UsaProxy() {
	/* get size
	 * NS: first case (window.Event available); IE: second case */
	var currentScrollPosX = (window.Event) ? window.pageXOffset : document.body.scrollLeft;
	var currentScrollPosY = (window.Event) ? window.pageYOffset : document.body.scrollTop;
	// if vertical scrollbar was moved new scrollbar position is logged
	if(lastScrollPosY_UsaProxy != currentScrollPosY) {
		writeLog_UsaProxy("scroll y=" + currentScrollPosY);
		// set last scrollbar position
		lastScrollPosY_UsaProxy = currentScrollPosY;
		saveLog_UsaProxy();
	}
	// if horizontal scrollbar was moved new scrollbar position is logged
	if(lastScrollPosX_UsaProxy != currentScrollPosX) {
		writeLog_UsaProxy("scroll x=" + currentScrollPosX);
		// set last scrollbar position
		lastScrollPosX_UsaProxy = currentScrollPosX;
		saveLog_UsaProxy();
	}
}

/* processes text selection event
 * function is invoked on mousedown */
function processSelection_UsaProxy() {
		var currentSelection;
		// NS
		if (window.getSelection) currentSelection = window.getSelection();
		// safari, konqueror
		else if (document.getSelection) currentSelection = document.getSelection();
		// IE
		else if (document.selection) currentSelection = document.selection.createRange().text;
		
		// if selection not empty and new text was selected, log select event
		if(currentSelection != "" && lastSelection_UsaProxy != currentSelection) {
			writeLog_UsaProxy("select text=" + escape(currentSelection));
			// set last selected text
			lastSelection_UsaProxy = currentSelection;
			saveLog_UsaProxy();
			return true;
		}
		return false;
}

/* NS processes text selection event in textfields/areas
 * since NS doesn't capture any selected text in text fields/areas over getSelection
 * function is invoked on select */
function processSelectionNS_UsaProxy(e) {
	/* get target
	 * NS: first case (window.Event available); IE: second case (not necessary) */
	var ev 		= (window.Event) ? e : window.event;
	var target 	= (window.Event) ? ev.target : ev.srcElement;
	// if selection not empty, log select event with selected text
	if (target.selectionStart!=target.selectionEnd) {
		writeLog_UsaProxy("select text=" + escape(target.value.substring(target.selectionStart,target.selectionEnd)) + generateEventString_UsaProxy(target));
		saveLog_UsaProxy();
	}
}
