/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class UsaProxy {
    private int port;
    private ProxyType proxyType;
    private LogFile logFile;
    private ProxyScript proxyScript;
    private HTTPTraffic httpTraffic;
    static final boolean DEBUG = false;

    public UsaProxy(int port, ProxyType proxyType) {
        this.port = port;
        this.proxyType = proxyType;
        this.proxyStart();
    }

    private void proxyStart() {
        System.out.println("Trying to start UsaProxy at port " + this.port);
        this.logFile = new LogFile();
        this.proxyScript = new ProxyScript();
        this.httpTraffic = new HTTPTraffic();
        try {
            ServerSocket server = new ServerSocket(this.port);
            System.out.println("UsaProxy started at port " + this.port);
            System.out.println("UsaProxy ready for accepting incoming connections");
            while (true) {
                Socket clientConnect = server.accept();
                new ClientRequest(clientConnect, this);
            }
        }
        catch (IOException e) {
            System.err.println("\nAn ERROR occured while starting UsaProxy:\n" + e);
            System.exit(1);
            return;
        }
    }

    public static void main(String[] args) {
        block14: {
            try {
                if (args.length == 4) {
                    InetAddress remoteAddress = null;
                    try {
                        remoteAddress = InetAddress.getByName(args[1]);
                    }
                    catch (UnknownHostException e) {
                        System.err.println("\nAn ERROR occured while retrieving remote proxy/server address:\n" + e);
                        System.err.println("Usage: java UsaProxy <port> [<remote proxy/server ip-address>] [<remote proxy/server port>] [transparent|server]");
                        System.exit(1);
                    }
                    try {
                        if (Integer.parseInt(args[2]) >= 0 && Integer.parseInt(args[2]) <= 65535) {
                            ProxyType proxyType = args[3].equals("transparent") ? new TransparentProxy(remoteAddress, Integer.parseInt(args[2])) : (args[3].equals("transparentremote") ? new TransparentProxy(remoteAddress, Integer.parseInt(args[2])) : (args[3].equals("server") ? new ServerProxy(remoteAddress, Integer.parseInt(args[2])) : new RemoteProxy(remoteAddress, Integer.parseInt(args[2]))));
                            new UsaProxy(Integer.parseInt(args[0]), proxyType);
                            break block14;
                        }
                        System.err.println("\nAn ERROR occured while instantiating remote/transparent/server proxy!\nUsage: java UsaProxy <port> [<remote proxy/server ip-address>] [<remote proxy/server port>] [transparent|transparentremote|server|remote]");
                        System.exit(1);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("\nAn ERROR occured while binding UsaProxy to port " + Integer.parseInt(args[0]) + " and remote port " + Integer.parseInt(args[2]) + ":\n" + e);
                        System.exit(1);
                    }
                    break block14;
                }
                if (args.length == 1) {
                    try {
                        new UsaProxy(Integer.parseInt(args[0]), new Proxy());
                    }
                    catch (NumberFormatException e) {
                        System.err.println("\nAn ERROR occured while binding UsaProxy to port " + Integer.parseInt(args[0]) + ":\n" + e);
                        System.err.println("Usage: java UsaProxy <port>");
                        System.exit(1);
                    }
                } else if (args.length == 0) {
                    new UsaProxy(8000, new Proxy());
                } else {
                    System.err.println("\nAn ERROR occured while instantiating remote/transparent/server proxy!\nFalse number of arguments!\nUsage: java UsaProxy <port> [<remote proxy/server ip-address>][<remote proxy/server port>] [transparent|transparentremote|server|remote]");
                    System.exit(1);
                }
            }
            catch (Exception e) {
                System.err.println("\nAn ERROR occured while starting UsaProxy:\n" + e);
                System.exit(1);
            }
        }
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public ProxyScript getProxyScript() {
        return this.proxyScript;
    }

    public HTTPTraffic getHttpTraffic() {
        return this.httpTraffic;
    }
}

