/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Map;

public class SocketData {
    private Socket socket;
    private OrderedHashtable headers;
    private InputStream in;
    private OutputStream out;

    public SocketData(Socket socket) {
        this.socket = socket;
        this.headers = new OrderedHashtable();
    }

    public void getInputStream() throws IOException {
        this.in = this.socket.getInputStream();
    }

    public void getOutputStream() throws IOException {
        this.out = this.socket.getOutputStream();
    }

    public void closeInputStream() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public void closeOutputStream() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    public void closeSocket() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public InputStream getIn() {
        return this.in;
    }

    public void setIn(InputStream in) {
        this.in = in;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public OrderedHashtable getHeaders() {
        return this.headers;
    }

    public void setHeaders(OrderedHashtable headers) {
        this.headers = headers;
    }

    public InputStream readHeaders(InputStream in) throws IOException {
        int b = 0;
        int len = 0;
        int colonIndex = -1;
        if (in == null) {
            in = new BufferedInputStream(in);
        }
        if (this.getHeaders() == null) {
            this.setHeaders(new OrderedHashtable());
        }
        boolean readTooMuch = false;
        ByteArrayOutputStream buf = new ByteArrayOutputStream(4097);
        while (true) {
            String value;
            String name;
            if (!readTooMuch) {
                b = (byte)in.read();
            }
            if (b == -1) break;
            readTooMuch = false;
            if (b != 13 && b != 10) {
                if (b == 58 && colonIndex == -1) {
                    colonIndex = len;
                }
                ++len;
                buf.write(b);
                continue;
            }
            if (b == 13) continue;
            if (len == 0) break;
            b = (byte)in.read();
            readTooMuch = true;
            if (b == 32 || b == 9) continue;
            buf.close();
            byte[] hdata = buf.toByteArray();
            buf.reset();
            if (colonIndex != -1) {
                String tmpString = new String(hdata, 0, len, "utf-8");
                if (HTTPData.isRequestLine(tmpString)) {
                    name = tmpString;
                    value = "";
                } else {
                    name = new String(hdata, 0, colonIndex, "utf-8");
                    value = new String(hdata, colonIndex + 2, len - 2 - colonIndex, "utf-8");
                }
                colonIndex = -1;
            } else {
                name = new String(hdata, 0, len, "utf-8");
                value = "";
            }
            if (value == "") {
                this.getHeaders().add(0, name, value);
            } else {
                this.getHeaders().put(name, value);
            }
            len = 0;
        }
        return in;
    }

    public void printHeaders() {
        StringBuffer headers = new StringBuffer();
        for (Map.Entry me : this.getHeaders().entrySet()) {
            String key = (String)me.getKey();
            if (key == null) continue;
            if (HTTPData.isStatusLine(key.trim())) {
                headers.insert(0, String.valueOf(key) + "\r\n");
                continue;
            }
            String value2 = (String)me.getValue();
            headers.append(key).append(": ").append(value2).append("\r\n");
        }
        headers.append("\r\n");
        System.err.println("Response headers: " + headers);
    }

    public void sendErrorMessage(Exception err, String get, String host) {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(this.getOut()));
        out.println("HTTP/1.0 200 ");
        out.println("Content-Type: text/plain");
        out.println();
        out.println("GET/POST:  " + get);
        out.println("HOST: " + host);
        out.println("Error!");
        out.println(err);
        out.flush();
    }
}

