/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class ServerRequest
extends Thread {
    private SocketData client;
    private SocketData server;
    private ClientRequest clientRequest;

    public ServerRequest(SocketData client, SocketData server, ClientRequest clientRequest) throws Exception {
        this.client = client;
        this.server = server;
        this.clientRequest = clientRequest;
        this.start();
    }

    public void run() {
        try {
            this.server.setOut(new DataOutputStream(new BufferedOutputStream(this.server.getOut())));
            StringBuffer headers = new StringBuffer();
            for (Map.Entry me : this.client.getHeaders().entrySet()) {
                String key = (String)me.getKey();
                if (key == null) continue;
                if (HTTPData.isRequestLine(key.trim())) {
                    headers.insert(0, String.valueOf(key) + "\r\n");
                    continue;
                }
                String value = (String)me.getValue();
                headers.append(key).append(": ").append(value).append("\r\n");
            }
            headers.append("\r\n");
            this.server.getOut().write(headers.toString().getBytes("utf-8"));
            this.server.getOut().flush();
            if (this.clientRequest.getHttpTraffic().isLogHttpTraffic()) {
                this.clientRequest.getHttpTraffic().store(this.clientRequest.getHttpTrafficIndex(), "##### Request #####\r\n\r\n" + headers.toString());
            }
            if (this.client.getIn() != null) {
                int requestLength;
                byte[] request = new byte[4096];
                while ((requestLength = this.client.getIn().read(request)) != -1) {
                    if (requestLength <= 0) continue;
                    this.server.getOut().write(request, 0, requestLength);
                    this.server.getOut().flush();
                    if (!this.clientRequest.getHttpTraffic().isLogHttpTraffic()) continue;
                    this.clientRequest.getHttpTraffic().store(this.clientRequest.getHttpTrafficIndex(), request, 0, requestLength);
                }
            }
            this.server.getOut().flush();
        }
        catch (IOException e) {
            System.err.println("\nAn ERROR occured while sending request: " + e);
        }
    }
}

