/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;

public class ServerProxy
implements ProxyType {
    private InetAddress serverAddress;
    private InetAddress hostAddress;
    private int serverPort;

    public ServerProxy() {
    }

    public ServerProxy(InetAddress hostAddress, int serverPort) {
        this.serverPort = serverPort;
        this.hostAddress = hostAddress;
        try {
            this.serverAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e1) {
            System.err.println("\nAn ERROR occured while defining serverAddress: " + e1);
        }
    }

    public Socket getServerConnect() throws Exception {
        return new Socket(this.serverAddress.getHostName(), this.serverPort);
    }

    public String getRequestLine(String method, URL url) {
        return String.valueOf(method) + " " + url.getFile() + " HTTP/1.0";
    }

    public String getScriptString() {
        return "<script src='http://" + this.hostAddress.getHostName() + "/usaproxylolo/proxyscript.js' type='text/javascript'></script>";
    }

    public void setRequestURL(URL url) {
    }
}

