/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class OrderedHashtable {
    private Vector orderedKeys;
    private Vector orderedKeysLower;
    private Hashtable hashTable;

    public OrderedHashtable() {
        this.orderedKeys = new Vector();
        this.orderedKeysLower = new Vector();
        this.hashTable = new Hashtable();
    }

    public OrderedHashtable(int initialCapacity) {
        this.orderedKeys = new Vector(initialCapacity);
        this.orderedKeysLower = new Vector(initialCapacity);
        this.hashTable = new Hashtable(initialCapacity);
    }

    public synchronized String put(String key, String value) {
        int i = this.orderedKeys.indexOf(key);
        if (i == -1) {
            this.orderedKeys.addElement(key);
            this.orderedKeysLower.addElement(key.toLowerCase());
        } else {
            this.orderedKeys.setElementAt(key, i);
            this.orderedKeysLower.setElementAt(key.toLowerCase(), i);
        }
        return this.hashTable.put(key, value);
    }

    public synchronized void add(int index, String key, String value) {
        int i = this.orderedKeys.indexOf(key);
        if (i == -1) {
            this.orderedKeys.add(index, key);
            this.orderedKeysLower.add(index, key.toLowerCase());
        } else {
            this.orderedKeys.setElementAt(key, i);
            this.orderedKeysLower.setElementAt(key.toLowerCase(), i);
        }
        this.hashTable.put(key, value);
    }

    public synchronized String get(String lowerKey) {
        if (this.getLowerIndex(lowerKey) >= 0) {
            String key = (String)this.orderedKeys.elementAt(this.getLowerIndex(lowerKey));
            return (String)this.hashTable.get(key);
        }
        return null;
    }

    public synchronized Enumeration keys() {
        return this.orderedKeys.elements();
    }

    public synchronized Enumeration elements() {
        int s = this.hashTable.size();
        Vector<String> elements = new Vector<String>(s);
        int i = 0;
        while (i < s) {
            elements.addElement(this.elementAt(i));
            ++i;
        }
        return elements.elements();
    }

    public synchronized Set entrySet() {
        return this.hashTable.entrySet();
    }

    public synchronized String elementAt(int index) throws ArrayIndexOutOfBoundsException {
        if (index < this.orderedKeys.size()) {
            String key = (String)this.orderedKeys.elementAt(index);
            if ((String)this.hashTable.get(key) != "") {
                return (String)this.hashTable.get(key);
            }
            return key;
        }
        return null;
    }

    public synchronized String keyAt(int index) throws ArrayIndexOutOfBoundsException {
        if (index < this.orderedKeys.size()) {
            return (String)this.orderedKeys.elementAt(index);
        }
        return null;
    }

    public synchronized int getIndex(String lowerKey) {
        if (this.getLowerIndex(lowerKey) >= 0) {
            String key = (String)this.orderedKeys.elementAt(this.getLowerIndex(lowerKey));
            return this.orderedKeys.indexOf(key);
        }
        return -1;
    }

    public synchronized int getLowerIndex(String key) {
        return this.orderedKeysLower.indexOf(key.toLowerCase());
    }

    public synchronized boolean containsKey(String lowerKey) {
        if (this.getLowerIndex(lowerKey) >= 0) {
            String key = (String)this.orderedKeys.elementAt(this.getLowerIndex(lowerKey));
            return this.hashTable.containsKey(key);
        }
        return false;
    }

    public synchronized void remove(String lowerKey) {
        String key = (String)this.orderedKeys.elementAt(this.getLowerIndex(lowerKey));
        this.orderedKeys.removeElement(key);
        this.hashTable.remove(key);
        this.orderedKeysLower.removeElement(lowerKey.toLowerCase());
    }

    public synchronized void removeElementAt(int i) {
        String key = (String)this.orderedKeys.elementAt(i);
        this.orderedKeysLower.removeElementAt(i);
        this.orderedKeys.removeElementAt(i);
        this.hashTable.remove(key);
    }

    public synchronized void clear() {
        this.orderedKeysLower.removeAllElements();
        this.orderedKeys.removeAllElements();
        this.hashTable.clear();
    }

    public synchronized int size() {
        return this.orderedKeys.size();
    }

    public synchronized void ensureCapacity(int capacity) {
        this.orderedKeysLower.ensureCapacity(capacity);
        this.orderedKeys.ensureCapacity(capacity);
    }
}

