/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class HTTPTraffic {
    private int index;
    private boolean logHttpTraffic;

    public HTTPTraffic() {
        this.doHttpTrafficLogging();
        if (this.logHttpTraffic) {
            this.index = this.getHttpTrafficIndex(false);
        }
    }

    public synchronized int getHttpTrafficIndex(boolean fromClient) {
        byte[] buffer = new byte[80];
        int clientIndex = 0;
        try {
            FileInputStream fis = new FileInputStream("httpTraffic/httpTraffic.txt");
            int len = fis.read(buffer, 0, fis.available());
            String str = new String(buffer, 0, len);
            clientIndex = Integer.parseInt(str);
            fis.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("\nAn ERROR occured: httpTraffic file not found:\n");
            e.printStackTrace();
            try {
                FileOutputStream fos = new FileOutputStream("httpTraffic/httpTraffic.txt", false);
                fos.write("0".getBytes());
                clientIndex = 0;
                fos.flush();
                fos.close();
                System.err.println("httpTraffic file was created with index 0");
            }
            catch (IOException ie) {
                System.err.println("\nAn ERROR occured while creating httpTraffic:\n" + ie);
            }
        }
        catch (IOException ie) {
            System.err.println("\nAn ERROR occured while getting HTTPTraffic index:\n" + ie);
        }
        this.index = clientIndex;
        if (fromClient) {
            this.increaseHttpTrafficIndex();
        }
        this.notifyAll();
        return clientIndex;
    }

    protected void doHttpTrafficLogging() {
        byte[] buffer = new byte[80];
        this.index = 0;
        try {
            FileInputStream fis = new FileInputStream("httpTraffic/logHttpTraffic.txt");
            int len = fis.read(buffer, 0, fis.available());
            String str = new String(buffer, 0, len);
            Boolean doLog = new Boolean(str);
            this.logHttpTraffic = doLog;
            fis.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("\nAn ERROR occured: httpTraffic file not found:\n" + e);
            try {
                FileOutputStream fos = new FileOutputStream("httpTraffic/logHttpTraffic.txt", false);
                fos.write("true".getBytes());
                this.logHttpTraffic = true;
                fos.flush();
                fos.close();
                System.err.println("logHttpTraffic file was created with value true");
            }
            catch (IOException ie) {
                System.err.println("\nAn ERROR occured while creating httpTraffic:\n" + ie);
            }
        }
        catch (IOException ie) {
            System.err.println("\nAn ERROR occured while getting HTTPTraffic index:\n" + ie);
        }
    }

    protected void increaseHttpTrafficIndex() {
        try {
            FileOutputStream fos = new FileOutputStream("httpTraffic/httpTraffic.txt", false);
            fos.write(("" + (this.index + 1)).getBytes());
            ++this.index;
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("\nAn ERROR occured: httpTraffic file not found:\n" + e);
        }
        catch (IOException ie) {
            System.err.println("\nAn ERROR occured while increasing httpTraffic index:\n" + ie);
        }
        this.notifyAll();
    }

    public void store(int index, String data) {
        try {
            FileOutputStream fos = new FileOutputStream("httpTraffic/log/httpTraffic" + index + ".txt", true);
            fos.write(data.getBytes("utf-8"));
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("\nAn ERROR occured: txt file with index " + index + " not found:\n" + e);
        }
        catch (IOException ie) {
            System.err.println("\nAn ERROR occured while storing data to file with index " + index + ":\n" + ie);
        }
    }

    public void store(int index, byte[] data, int off, int length) {
        try {
            FileOutputStream fos = new FileOutputStream("httpTraffic/log/httpTraffic" + index + ".txt", true);
            fos.write(data, off, length);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("\nAn ERROR occured: txt file with index " + index + " not found:\n" + e);
        }
        catch (IOException ie) {
            System.err.println("\nAn ERROR occured while storing data to file with index " + index + ":\n" + ie);
        }
    }

    public boolean isLogHttpTraffic() {
        return this.logHttpTraffic;
    }
}

