/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Map;

public class ClientRequest
extends Thread {
    private UsaProxy usaProxy;
    private SocketData client;
    private SocketData server;
    private String get;
    private String host;
    private boolean isHtmlStream;
    private boolean isNotFoundMessage;
    private StringBuffer data;
    private boolean testSeiteRequested;
    private boolean proxyScriptRequested;
    private boolean logRequested;
    private String logData;
    private int httpTrafficIndex;

    public ClientRequest(Socket socket, UsaProxy usaProxy) {
        this.client = new SocketData(socket);
        this.usaProxy = usaProxy;
        this.proxyScriptRequested = false;
        this.logRequested = false;
        this.testSeiteRequested = false;
        this.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            this.client.getInputStream();
            this.client.getOutputStream();
            this.get = "";
            this.host = "";
            this.client.setIn(this.processRequest(this.client.getIn()));
            if (this.testSeiteRequested) {
                this.usaProxy.getProxyScript().send(this.client.getOut(), "testseite.html", this.client.getSocket(), "");
                return;
            }
            if (this.proxyScriptRequested) {
                String sessionID = "";
                this.client.printHeaders();
                if (this.client.getHeaders().containsKey("Cookie")) {
                    sessionID = this.client.getHeaders().get("Cookie");
                }
                if (sessionID.indexOf("userUsaProxy") > -1) {
                    int startPos = sessionID.indexOf("userUsaProxy") + "userUsaProxy".length() + 1;
                    int endPos = sessionID.indexOf(";", startPos) > -1 ? sessionID.indexOf(";", startPos) : sessionID.length();
                    sessionID = sessionID.substring(startPos, endPos).trim();
                } else {
                    sessionID = this.generateSessionID(12);
                }
                this.usaProxy.getProxyScript().send(this.client.getOut(), "proxyscript.js", this.client.getSocket(), sessionID);
                return;
            }
            if (this.logRequested) {
                this.usaProxy.getLogFile().log(this.client.getOut(), this.logData, this.client.getSocket());
                return;
            }
            try {
                this.usaProxy.getProxyType().setRequestURL(new URL(this.get));
                this.server = new SocketData(this.usaProxy.getProxyType().getServerConnect());
            }
            catch (Exception err) {
                System.err.println("\nAn ERROR occured while connecting to the server:\n" + err);
                err.printStackTrace();
                this.client.sendErrorMessage(err, this.get, this.host);
                this.client.closeInputStream();
                this.client.closeOutputStream();
                this.client.closeSocket();
                if (this.server != null) {
                    this.server.closeSocket();
                }
                try {
                    this.client.closeInputStream();
                    this.client.closeOutputStream();
                    this.server.closeInputStream();
                    this.server.closeOutputStream();
                    this.client.closeSocket();
                    this.server.closeSocket();
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }
        catch (Exception e) {
            System.err.println("\nAn ERROR occured while negotiating with the server:\n" + e);
            e.printStackTrace();
            return;
        }
        {
            this.server.getInputStream();
            this.server.getOutputStream();
            if (this.usaProxy.getHttpTraffic().isLogHttpTraffic()) {
                this.httpTrafficIndex = this.usaProxy.getHttpTraffic().getHttpTrafficIndex(true);
            }
            new ServerRequest(this.client, this.server, this);
            this.processResponse(this.server.getIn());
            return;
        }
        finally {
            try {
                this.client.closeInputStream();
                this.client.closeOutputStream();
                this.server.closeInputStream();
                this.server.closeOutputStream();
                this.client.closeSocket();
                this.server.closeSocket();
            }
            catch (Exception exception) {}
        }
    }

    private InputStream processRequest(InputStream in) {
        String method = "";
        try {
            in = this.client.readHeaders(in);
            String url = this.client.getHeaders().elementAt(0);
            System.err.println(url);
            if (!HTTPData.isRequestLine(url)) {
                int i = 0;
                while (i < this.client.getHeaders().size()) {
                    if (HTTPData.isRequestLine(this.client.getHeaders().keyAt(i))) {
                        url = this.client.getHeaders().keyAt(i);
                    }
                    ++i;
                }
            }
            this.client.getHeaders().remove(url);
            method = url.substring(0, url.indexOf(" ")).trim();
            url = url.substring(url.indexOf(" ")).trim();
            url = url.toUpperCase().lastIndexOf("HTTP") >= 0 ? url.substring(0, url.toUpperCase().lastIndexOf("HTTP")).trim() : url.trim();
            this.get = url;
            if (url.toLowerCase().indexOf("usaproxylolo/testseite.html") != -1) {
                this.testSeiteRequested = true;
                return null;
            }
            if (url.toLowerCase().indexOf("usaproxylolo/proxyscript.js") != -1) {
                this.proxyScriptRequested = true;
                return null;
            }
            if (url.toLowerCase().indexOf("usaproxylolo/img.jpg") != -1) {
                this.logRequested = true;
                this.logData = url.substring(url.indexOf("?") + 1);
                return null;
            }
            if (url.toLowerCase().startsWith("/")) {
                url = "http://" + InetAddress.getLocalHost() + url;
            }
            URL geturl = new URL(url);
            this.client.getHeaders().add(0, this.usaProxy.getProxyType().getRequestLine(method, geturl), "");
            this.host = this.client.getHeaders().get("Host");
            this.client.getHeaders().put("X-Forwarded-For", this.client.getSocket().getInetAddress().getHostAddress());
            this.client.getHeaders().put("Accept-Encoding", "identity");
            this.client.getHeaders().put("Connection", "close");
            if (this.client.getHeaders().containsKey("Proxy-Connection")) {
                this.client.getHeaders().remove("Proxy-Connection");
            }
            if (this.client.getHeaders().containsKey(HTTPData.HEADER_CONNECTION_KEEPALIVE)) {
                this.client.getHeaders().remove(HTTPData.HEADER_CONNECTION_KEEPALIVE);
            }
            this.client.getHeaders().put("Pragma", "no-cache");
            this.client.getHeaders().put("X-UsaProxy", "client");
        }
        catch (IOException e) {
            e.printStackTrace();
            if (this.client.getSocket() != null) {
                System.err.println("\nAn ERROR occured while processing request: " + this.client.getHeaders().elementAt(0) + " from client " + this.client.getSocket().getInetAddress().getHostName() + ":\n" + e);
            }
            System.err.println("\nAn ERROR occured while processing request: \n" + e);
        }
        if (method.equals("POST")) {
            return in;
        }
        return null;
    }

    private void processResponse(InputStream in) {
        this.server.setHeaders(new OrderedHashtable());
        try {
            in = this.server.readHeaders(in);
        }
        catch (IOException e) {
            if (this.server.getSocket() != null) {
                System.err.println("\nAn ERROR occured while reading response headers: from server " + this.server.getSocket().getInetAddress().getHostName() + ":\n" + e);
            }
            System.err.println("\nAn ERROR occured while reading response headers: \n" + e);
        }
        try {
            InetAddress i = InetAddress.getLocalHost();
            String newVia = "";
            if (this.server.getHeaders().containsKey("Via")) {
                newVia = String.valueOf(this.server.getHeaders().get("Via")) + ", ";
            }
            newVia = String.valueOf(newVia) + i.getHostName() + " (UsaProxy/2.0)";
            this.server.getHeaders().put("Via", newVia);
        }
        catch (UnknownHostException e1) {
            System.err.println("\nAn ERROR occured while reading generating VIA header: " + e1);
        }
        String contentType = this.server.getHeaders().get("Content-Type");
        this.isHtmlStream = contentType != null && HTTPData.isHTMLType(contentType);
        String status = this.server.getHeaders().elementAt(0);
        if (!HTTPData.isStatusLine(status)) {
            int j = 0;
            if (j < this.server.getHeaders().size()) {
                if (HTTPData.isStatusLine(this.server.getHeaders().keyAt(j))) {
                    status = this.server.getHeaders().keyAt(j);
                }
            }
        }
        this.isNotFoundMessage = status != null && status.indexOf("404") != -1;
        if (this.isHtmlStream && !this.isNotFoundMessage) {
            in = this.enhanceResponse(in);
        }
        this.sendHeaders(this.client.getOut());
        this.sendResponse();
    }

    private InputStream enhanceResponse(InputStream in) {
        int b = 0;
        boolean readTooMuch = false;
        boolean noHead = true;
        boolean headStarted = false;
        this.data = new StringBuffer();
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream(4097);
            while (true) {
                byte[] bdata;
                if (!readTooMuch) {
                    b = (byte)in.read();
                }
                if (b == -1) break;
                readTooMuch = false;
                if (!(!headStarted && b != 60 || headStarted && b != 62)) {
                    buf.write(b);
                    if (!headStarted) {
                        b = (byte)in.read();
                        if (b != 104 && b != 72) {
                            buf.write(b);
                            continue;
                        }
                        buf.write(b);
                        b = (byte)in.read();
                        if (b != 101 && b != 69) {
                            buf.write(b);
                            continue;
                        }
                        buf.write(b);
                        b = (byte)in.read();
                        if (b != 97 && b != 65) {
                            buf.write(b);
                            continue;
                        }
                        buf.write(b);
                        b = (byte)in.read();
                        if (b != 100 && b != 68) {
                            buf.write(b);
                            continue;
                        }
                        headStarted = true;
                        buf.write(b);
                        b = (byte)in.read();
                        if (b != 62) {
                            buf.write(b);
                            continue;
                        }
                        buf.write(b);
                    }
                    System.out.println("\nUsaProxy script tag was added to request " + this.client.getHeaders().elementAt(0) + "\n" + "Monitoring was started at client " + this.client.getSocket().getInetAddress().getHostName() + " (" + this.client.getSocket().getInetAddress().getHostAddress() + ")");
                    headStarted = false;
                    readTooMuch = true;
                    noHead = false;
                    buf.close();
                    bdata = buf.toByteArray();
                    buf.reset();
                    String dataBefore = new String(bdata, "utf-8");
                    String scriptString = this.usaProxy.getProxyType().getScriptString();
                    scriptString = this.insertID(scriptString);
                    this.data.append(dataBefore).append(scriptString);
                    if (this.server.getHeaders().containsKey("Content-Length")) {
                        int contentLength = Integer.parseInt(this.server.getHeaders().get("Content-Length"));
                        this.server.getHeaders().put("Content-Length", "" + (contentLength += scriptString.getBytes().length));
                    }
                    break;
                }
                buf.write(b);
                if (!noHead) continue;
                buf.close();
                bdata = buf.toByteArray();
                buf.reset();
                this.data.append(new String(bdata, "utf-8"));
            }
        }
        catch (IOException e) {
            if (this.server.getSocket() != null) {
                System.err.println("\nAn ERROR occured while enhancing response: from server " + this.server.getSocket().getInetAddress().getHostName() + ":\n" + e);
            }
            System.err.println("\nAn ERROR occured while enhancing response: \n" + e);
        }
        return in;
    }

    private String insertID(String scriptString) {
        StringBuffer scriptStringID = new StringBuffer(scriptString);
        String proxyString = "<script ";
        int insertPos = scriptString.indexOf(proxyString) + proxyString.length();
        scriptStringID.insert(insertPos, "id='proxyScript_UsaProxy' ");
        scriptString = scriptStringID.toString();
        scriptStringID = new StringBuffer(scriptString);
        proxyString = "proxyscript.js";
        insertPos = scriptString.indexOf(proxyString) + proxyString.length();
        scriptStringID.insert(insertPos, "?id=" + this.httpTrafficIndex);
        scriptString = scriptStringID.toString();
        return scriptString;
    }

    private void sendHeaders(OutputStream out) {
        this.client.setOut(new DataOutputStream(new BufferedOutputStream(this.client.getOut())));
        StringBuffer headers = new StringBuffer();
        for (Map.Entry me : this.server.getHeaders().entrySet()) {
            String key = (String)me.getKey();
            if (key == null) continue;
            if (HTTPData.isStatusLine(key.trim())) {
                headers.insert(0, String.valueOf(key) + "\r\n");
                continue;
            }
            String value = (String)me.getValue();
            headers.append(key).append(": ").append(value).append("\r\n");
        }
        headers.append("\r\n");
        try {
            this.client.getOut().write(headers.toString().getBytes("utf-8"));
            this.client.getOut().flush();
            if (this.isHtmlStream && !this.isNotFoundMessage && this.usaProxy.getHttpTraffic().isLogHttpTraffic()) {
                this.logData = String.valueOf(this.dateStamp()) + " " + this.get + " serverdata " + this.httpTrafficIndex;
                this.usaProxy.getLogFile().log(null, this.logData, this.client.getSocket());
                this.usaProxy.getHttpTraffic().store(this.httpTrafficIndex, "\r\n\r\n##### Response #####\r\n\r\n" + headers.toString());
            }
        }
        catch (IOException e) {
            if (this.client.getSocket() != null) {
                System.err.println("\nAn ERROR occured while sending response headers: to client " + this.client.getSocket().getInetAddress().getHostName() + ":\n" + e);
            }
            System.err.println("\nAn ERROR occured while sending response headers: \n" + e);
        }
    }

    private void sendResponse() {
        byte[] response = new byte[4096];
        try {
            int responseLength;
            if (this.isHtmlStream && !this.isNotFoundMessage) {
                this.client.getOut().write(this.data.toString().getBytes("utf-8"));
                this.client.getOut().flush();
                if (this.usaProxy.getHttpTraffic().isLogHttpTraffic()) {
                    this.usaProxy.getHttpTraffic().store(this.httpTrafficIndex, this.data.toString());
                }
            }
            while ((responseLength = this.server.getIn().read(response)) != -1) {
                if (responseLength <= 0) continue;
                this.client.getOut().write(response, 0, responseLength);
                this.client.getOut().flush();
                if (!this.isHtmlStream || this.isNotFoundMessage || !this.usaProxy.getHttpTraffic().isLogHttpTraffic()) continue;
                this.usaProxy.getHttpTraffic().store(this.httpTrafficIndex, response, 0, responseLength);
            }
        }
        catch (IOException e) {
            if (this.client.getSocket() != null) {
                System.err.println("\nAn ERROR occured while sending response: to client " + this.client.getSocket().getInetAddress().getHostName() + ":\n" + e);
            }
            System.err.println("\nAn ERROR occured while sending response: \n" + e);
        }
    }

    public String dateStamp() {
        Calendar now = Calendar.getInstance();
        return String.valueOf(now.get(1)) + "-" + this.completeDateVals(now.get(2) + 1) + "-" + this.completeDateVals(now.get(5)) + "," + this.completeDateVals(now.get(11)) + ":" + this.completeDateVals(now.get(12)) + ":" + this.completeDateVals(now.get(13));
    }

    public String completeDateVals(int dateVal) {
        String dateVals = "" + dateVal;
        if (dateVals.length() < 2) {
            return "0" + dateVal;
        }
        return dateVals;
    }

    public HTTPTraffic getHttpTraffic() {
        return this.usaProxy.getHttpTraffic();
    }

    public int getHttpTrafficIndex() {
        return this.httpTrafficIndex;
    }

    public void setHttpTrafficIndex(int httpTrafficIndex) {
        this.httpTrafficIndex = httpTrafficIndex;
    }

    public String generateSessionID(int positions) {
        int intI = 0;
        String strLargeText = "";
        int intValue = 0;
        String[] arrCharacters = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        intI = 0;
        while (intI < positions) {
            intValue = this.randRange_UsaProxy(0.0, arrCharacters.length - 1, intI);
            strLargeText = String.valueOf(strLargeText) + arrCharacters[intValue];
            ++intI;
        }
        return strLargeText;
    }

    public int randRange_UsaProxy(double intFrom, double intTo, double intSeed) {
        intFrom = Math.floor(intFrom);
        intTo = Math.floor(intTo);
        return (int)Math.floor(intFrom + (intTo - intFrom + 1.0) * Math.random());
    }
}

