package simpleFilter;

import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleGroup;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.effect.SepiaTone;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

import java.io.File;

/**
 * Created by Philmac on 17.05.16.
 * Updated by Tobi S. on 18.05.16
 */
public class SimpleFilter extends Application {

    private ImageView defImgView;
    private SepiaTone sepiaTone = new SepiaTone();
    private GaussianBlur gaussianBlur = new GaussianBlur();
    private Effect currentEffect;
    private Slider effectStrengthSlider;

    @Override
    public void start(Stage primaryStage) throws Exception {

        // ======================================================
        // Default values
        // ======================================================
        final int imgWidth = 800;
        final int imgHeight = 600;
        final boolean preserveImageRatio = true;
        final boolean useImageSmoothing = true;
        final int defaultPadding = 10;
        // this will only work, if you mark the "assets" folder as resource root
        // details are provided in the tutorial slides.
        final String defaultImagePath = "beispielBild.png";


        // the maximum value of the GaussianBlur's radius property is 63
        // https://docs.oracle.com/javafx/2/api/javafx/scene/effect/GaussianBlur.html#radiusProperty()
        final double blurMax = 63.0;

        // the sepia effect is scaled from 0 to 1
        // https://docs.oracle.com/javafx/2/api/javafx/scene/effect/SepiaTone.html#levelProperty()
        final double sepiaMax = 1.0;

        final String sepiaFilter = "sepia";
        final String blurFilter = "blur";

        // ======================================================
        // GUI Elements
        // ======================================================
        Button openFile = new Button("Open File");

        ToggleGroup filterToggleGroup = new ToggleGroup();
        RadioButton sepiaRadio = new RadioButton(sepiaFilter);
        RadioButton blurRadio = new RadioButton(blurFilter);

        sepiaRadio.setUserData(sepiaFilter);
        blurRadio.setUserData(blurFilter);

        sepiaRadio.setToggleGroup(filterToggleGroup);
        blurRadio.setToggleGroup(filterToggleGroup);


        Image defImg = new Image(defaultImagePath, imgWidth, imgHeight, preserveImageRatio, useImageSmoothing);
        this.defImgView = new ImageView(defImg);
        this.defImgView.setFitHeight(imgHeight);
        this.defImgView.setFitWidth(imgWidth);
        this.defImgView.setPreserveRatio(preserveImageRatio);

        // for now, we assume that we start out with a sepia filter, but actually it doesn't matter.
        // this is overwritten when the user selects a radio button for the first time.
        this.effectStrengthSlider = new Slider(0, sepiaMax, sepiaMax / 2);
        // the slider should be about the same width as the image.
        this.effectStrengthSlider.setPrefWidth(defImg.getWidth());


        // ======================================================
        // Event Handler and Bindings
        // ======================================================

        // Open File with FileChooser
        openFile.setOnAction(e -> {
            try{
                FileChooser fileChooser = new FileChooser();
                // TODO step 1

                // we need to convert the file into a URL, as String.
                // TODO step 2

                // immediately apply the effect, if we have one.
                // TODO step 3

            }catch (Exception exception){
                System.out.println(exception.getMessage());
            }
        });

        // Selected Filter Change listener
        filterToggleGroup.selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            // the effect name is stored as user data inside the radio button.
            // we need to cast a lot.
            String newEffectName = (String)((RadioButton) newValue).getUserData();

            // we want to re-adjust the filter value to about the same position
            // after we switch filters.
            double relativeSliderValue = effectStrengthSlider.getValue() / effectStrengthSlider.getMax();

            switch (newEffectName){
                // update the slider maximum depending on the effect's maximum
                // update the currentEffect
                case sepiaFilter:
                    effectStrengthSlider.setMax(sepiaMax);
                    currentEffect = sepiaTone;
                    break;
                case blurFilter:
                    effectStrengthSlider.setMax(blurMax);
                    currentEffect = gaussianBlur;
                    break;
            }
            // now we shift the slider back to where it was before, only on a different scale.
            // this is usually so quick that the user does not see it.
            effectStrengthSlider.setValue(relativeSliderValue * effectStrengthSlider.getMax());
            // apply the newly resolved effect.
            defImgView.setEffect(currentEffect);
        });

        // we connect the scrollbar's value to the strength of the effect.
        // TODO step 4

        // ======================================================
        // Layout / Scene
        // ======================================================

        HBox hBoxTop = new HBox(defaultPadding);
        // add all the controls
        hBoxTop.getChildren().addAll(openFile, blurRadio, sepiaRadio, effectStrengthSlider);

        // root pane
        BorderPane borderPane = new BorderPane();
        borderPane.setTop(hBoxTop);
        borderPane.setCenter(defImgView);
        borderPane.setPadding(new Insets(defaultPadding,defaultPadding,defaultPadding,defaultPadding));


        Scene scene = new Scene(borderPane);

        primaryStage.setScene(scene);
        primaryStage.setTitle("Simple Filter");
        primaryStage.show();
    }

    public static void main(String[] args) {
        launch(args);
    }
}